// (C) Copyright 1999 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

#include "stdafx.h"
#include "input.h"
#include "DockPane.h"
#include "SampleListView.h"

/////////////////////////////////////////////////////////////////
Acad::ErrorStatus IPM::monitorInputPoint(
 
          // Output
          // If changedTooltipStr is kTrue
          // then newTooltipString has the new tooltip string in it.
          //
         bool&                             appendToTooltipStr,
          char*&                            additionalTooltipString,

          // Input/Output
          //
          AcGiViewportDraw*                   drawContext,

          // Input parameters:
          //
          AcApDocument*                       document,
          bool                                pointComputed,
          int                                 history,
          const AcGePoint3d&                  lastPoint,
          const AcGePoint3d&                  rawPoint,
          const AcGePoint3d&                  grippedPoint,
          const AcGePoint3d&                  cartesianSnappedPoint,
          const AcGePoint3d&                  osnappedPoint,
          AcDb::OsnapMask                     osnapMask,
          const AcArray<AcDbCustomOsnapMode*>& customOsnapModes,
          AcDb::OsnapMask                     osnapOverrides,
          const AcArray<AcDbCustomOsnapMode*>& customOsnapOverrides,
          const AcArray<AcDbObjectId>&        apertureEntities,
          const AcArray< AcDbObjectIdArray, AcArrayObjectCopyReallocator< AcDbObjectIdArray > >& 
                                              nestedApertureEntities,
          const AcArray<int>&                 gsSelectionMark,
          const AcArray<AcDbObjectId>&        keyPointEntities,
          const AcArray< AcDbObjectIdArray, AcArrayObjectCopyReallocator< AcDbObjectIdArray > >&
                                              nestedKeyPointEntities,
          const AcArray<int>&                 keyPointGsSelectionMark,
          const AcArray<AcGeCurve3d*>&        alignmentPaths,
          const AcGePoint3d&                  computedPoint,
          const char*                         tooltipString)
{
    if (pointComputed)
    {
    	if(m_pDlg)
		{
			if(apertureEntities.length() != 0)
			{
				AcDbDatabase* pDb = document->database();
				ASSERT(NULL != pDb);
				if(pDb)
				{
					for (int i = 0; i < apertureEntities.length(); i++)
					{
						if(m_oldId == apertureEntities[i]) //check if it's the same
						{
							return Acad::eOk;
						}
						else
						{
							m_oldId = apertureEntities[i]; //cache the last ent
						}
						
						//tell the dialog to get this OD
						m_pDlg->GetObjectData(apertureEntities[i]);
						
						if(m_pDlg->UseToolTips())
						{
							CString strToolTip;
							if(m_pDlg->GetToolTipString(strToolTip))
							{
								m_TooltipString = strToolTip;
								additionalTooltipString = m_TooltipString.GetBuffer(0);
								appendToTooltipStr = true;
							}
						}
					}
				}
			}        
		}
	}
    
    return Acad::eOk;
}

